

/**
 ******************************************************************************
 *
 * @file        MG32_Button_API.h
 * @brief       Button handle H file.
 
 * @par         Project
 *              Mouse
 * @version     V1.00
 * @date        2022/03/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 
#ifndef __BUTTON_H
#define __BUTTON_H

#include "MG32.h"
#include "MG32_Common_API.h"
#include "MG32_EXIC_DRV.h"

/**
 * @name  define
 */
///@{ 
 
/*Pin configure */ 
#define BTN_L_IOM_PIN            PINC(8)
#define BTN_R_IOM_PIN            PINC(9)
#define BTN_M_IOM_PIN            PINC(10)
#define BTN_BW_IOM_PIN           PINC(11)
#define BTN_FW_IOM_PIN           PINC(12)
                                   
#define BTN_L_IOM_AFS            0
#define BTN_R_IOM_AFS            0
#define BTN_M_IOM_AFS            0
#define BTN_BW_IOM_AFS           0
#define BTN_FW_IOM_AFS           0


/*Button control*/
#define BTN_Total                5            /*!< Total button.*/

#define BTN_DebounceTime         1            /*!< Button debounce.*/

#define BTN_L_Data               0            /*!< Data byte0 is Left     button status.*/
#define BTN_R_Data               1            /*!< Data byte1 is Right    button status.*/
#define BTN_M_Data               2            /*!< Data byte2 is Middle   button status.*/
#define BTN_BW_Data              3            /*!< Data byte3 is Backward button status.*/
#define BTN_FW_Data              4            /*!< Data byte4 is forward  button status.*/


///@}

/**
 * @name  typedef
 */
///@{

/*! @struct BTNCTR_TypeDef
    @brief  Button control parameter.
*/ 
typedef struct
{
    uint8_t             Button_ChangeFlag;            /*!< Button status change flag.*/
    uint8_t             ButtonStatus[BTN_Total];      /*!< Button status buffer.*/
    uint8_t             ButtonDebounceCnt[BTN_Total]; /*!< Button debounce counter.*/
    
}BTNCTR_TypeDef;
///@}


/**
 * @name  variables
 */
///@{
extern BTNCTR_TypeDef   BTN_CTR;

///@}


/**
 * @name  function
 */
///@{
void API_Button_Init(void);
void API_Button_GetStatus(void);
///@}


#endif








